//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "Utils.h"


@implementation Utils: NSObject

- (NSMutableString *)convertNSDataBytesToHexString:(NSData * _Nonnull)response {
    NSData *data = response;
    NSUInteger capacity = data.length * 2;
    NSMutableString *sbuf = [NSMutableString stringWithCapacity:capacity];
    const unsigned char *buf = data.bytes;
    NSInteger i;
    for (i=0; i<data.length; ++i) {
        [sbuf appendFormat:@"%02lX", (unsigned long)buf[i]];
    }
    return sbuf;
}

- (NSMutableString *)printNSDataBytesToHexString:(NSData * _Nonnull)response {
    NSData *data = response;
    NSUInteger capacity = data.length * 2;
    NSMutableString *sbuf = [NSMutableString stringWithCapacity:capacity];
    const unsigned char *buf = data.bytes;
    NSInteger i;
    for (i=0; i<data.length; ++i) {
        if( i < (data.length - 1)){
            [sbuf appendString:@"0x"];
            [sbuf appendFormat:@"%02lX", (unsigned long)buf[i]];
            [sbuf appendString:@", "];
        }
        else{
            [sbuf appendString:@"0x"];
            [sbuf appendFormat:@"%02lX", (unsigned long)buf[i]];
        }
    }
    return sbuf;
}

+ (NSString*) hexStringWithData: (unsigned char*) data ofLength: (NSUInteger) len
{
    NSMutableString *tmp = [NSMutableString string];
    for (NSUInteger i=0; i<len; i++)
        [tmp appendFormat:@"%02x", data[i]];
    return [NSString stringWithString:tmp];
}

- (NSData *)dataFromHexString:(NSString *) string {
    if([string length] % 2 == 1){
        string = [@"0"stringByAppendingString:string];
    }
    
    const char *chars = [string UTF8String];
    int i = 0, len = (int)[string length];
    
    NSMutableData *data = [NSMutableData dataWithCapacity:len / 2];
    char byteChars[3] = {'\0','\0','\0'};
    unsigned long wholeByte;
    
    while (i < len) {
        byteChars[0] = chars[i++];
        byteChars[1] = chars[i++];
        wholeByte = strtoul(byteChars, NULL, 16);
        [data appendBytes:&wholeByte length:1];
    }
    return data;
}

- (short *) byte2short:(Byte *)bytes size:(int)size resultSize:(int)resultSize{
    short *shorts = (short *)malloc(sizeof(short)*resultSize);
    for (int i=0; i < size/2; i++){
        shorts[i] = (bytes[i*2+1] << 8) | bytes[i*2];
    }
    return shorts;
}

- (Byte *) short2byte:(short *)shorts size:(int)size resultSize:(int)resultSize{
    Byte *bytes = (Byte *)malloc(sizeof(Byte)*resultSize);
    for (int i = 0; i < size; i++)
    {
        bytes[i * 2] = (Byte) (shorts[i] & 0x00FF);
        bytes[(i * 2) + 1] = (Byte) (shorts[i] >> 8);
        shorts[i] = 0;
    }
    return bytes;
}

-(bool) IsBitSet:(NSData *)values position:(int) position index:(int)index{
    const char *byte = [values bytes];
    if (byte == NULL)
        return false;
    int mask = 1 << index;
    return (byte[position] & mask)!=0;
}

@end
